/* Generator.cs
 *
 * This example generates a 100 kHz triangle waveform, 4 Vpp.
 *
 * Find more information on http://www.tiepie.com/LibTiePie .
 */

using System;
using TiePie.Hardware;

// Print library information:
PrintInfo.PrintLibraryInfo();

// Enable network search:
Network.AutoDetectEnabled = true;

// Update device list:
DeviceList.Update();

// Try to open a generator:
Generator? gen = null;

for (var i = 0u; i < DeviceList.Count; i++)
{
    using var item = DeviceList.GetItemByIndex(i);
    if (item.CanOpen(DeviceType.Generator))
    {
        gen = item.OpenGenerator();
        break;
    }
}

if (gen is null)
{
    Console.WriteLine("No generator available!");
    return 1;
}

try
{
    // Set signal type:
    gen.SignalType = SignalType.Triangle;

    // Set frequency:
    gen.Frequency = 100e3; // 100 kHz

    // Set amplitude:
    gen.Amplitude = 2; // 2 V

    // Set offset:
    gen.Offset = 0; // 0 V

    // Enable output:
    gen.OutputEnable = true;

    // Print Generator info:
    PrintInfo.PrintDeviceInfo(gen);

    // Start signal generation
    gen.Start();

    // Wait for keystroke:
    Console.WriteLine("Press Enter to stop signal generation...");
    Console.ReadLine();

    // Stop generator:
    gen.Stop();

    // Disable output:
    gen.OutputEnable = false;
}
catch (System.Exception e)
{
    Console.WriteLine($"Exception: {e.Message}");
    return 1;
}
finally
{
    // Close generator:
    gen.Dispose();
}

return 0;
