/* ListDevices.cs
 *
 * This example prints all the available devices to the screen.
 *
 * Find more information on http://www.tiepie.com/LibTiePie .
 */

using System;
using TiePie.Hardware;

// Print library information:
PrintInfo.PrintLibraryInfo();

// Enable network search:
Network.AutoDetectEnabled = true;

// Update device list:
DeviceList.Update();

// Get the number of connected devices:
var connectedDevices = DeviceList.Count;
if (connectedDevices == 0)
{
    Console.WriteLine("No devices found!");
    return 1;
}

Console.WriteLine();
Console.WriteLine("Available devices:");

for (var i = 0u; i < connectedDevices; i++)
{
    try
    {
        using var item = DeviceList.GetItemByIndex(i);
        Console.WriteLine($"  Name: {item.Name}");
        Console.WriteLine($"    Serial number  : {item.SerialNumber}");
        Console.WriteLine($"    Available types: {item.Types}");

        if (item.HasServer)
        {
            using var server = item.Server!;
            Console.WriteLine($"    Server         : {server.Url} ({server.Name})");
        }
    }
    catch (System.Exception e)
    {
        Console.WriteLine($"Exception: {e.Message}");
        return 1;
    }
}

return 0;
