/* OscilloscopeCombineHS3HS4.cs
 *
 * This example demonstrates how to create and open a combined instrument of all found Handyscope HS4 / Handyscope HS4 DIFF's.
 *
 * Find more information on http://www.tiepie.com/LibTiePie .
 */

using System;
using System.Collections.Generic;
using TiePie.Hardware;

// Print library information:
PrintInfo.PrintLibraryInfo();

// Update device list:
DeviceList.Update();

// Try to open all HS3/HS4(D) oscilloscopes:
ProductID[] allowedProductIDs = [ProductID.HS3, ProductID.HS4, ProductID.HS4D];
List<Oscilloscope> scps = [];
if (DeviceList.Count != 0)
{
    for (var i = 0u; i < DeviceList.Count; i++)
    {
        using var item = DeviceList.GetItemByIndex(i);
        if (Array.IndexOf(allowedProductIDs, item.ProductID) > -1 && item.CanOpen(DeviceType.Oscilloscope))
        {
            scps.Add(item.OpenOscilloscope());
            Console.WriteLine($"Found: {item.Name}, s/n: {item.SerialNumber}");
        }
    }
}

if (scps.Count <= 1)
{
    Console.WriteLine("Not enough HS3/HS4(D)\'s found, at least two required!");
    return 1;
}

try
{
    uint serialNumber;

    // Create and open combined instrument:
    using (var scp = DeviceList.CreateAndOpenCombinedOscilloscope(scps))
    {
        // Remove HS3/HS4(D) objects, not required anymore:
        scps.ForEach(x => x.Dispose());
        scps.Clear();

        // Print combined oscilloscope info:
        PrintInfo.PrintDeviceInfo(scp);

        // Get serial number, required for removing:
        serialNumber = scp.SerialNumber;
    }

    // Remove combined oscilloscope from the device list:
    DeviceList.RemoveDevice(serialNumber, false);
}
catch (System.Exception e)
{
    Console.WriteLine($"Exception: {e.Message}");
    return 1;
}

return 0;
