# ListDevices.py
#
# This example prints all the available devices to the screen.
#
# Find more information on http://www.tiepie.com/LibTiePie .

import sys
import libtiepie
from printinfo import *

# Print library info:
print_library_info()

# Enable network search:
libtiepie.network.auto_detect_enabled = True

# Search for devices:
libtiepie.device_list.update()

if len(libtiepie.device_list) > 0:
    print()
    print('Available devices:')

    for item in libtiepie.device_list:
        print(f'  Name: {item.name}')
        print(f'    Serial number  : {item.serial_number}')
        print(f'    Available types: {libtiepie.device_type_str(item.types)}')

        if item.has_server:
            print(f'    Server         : {item.server.url} ({item.server.name})')
else:
    print('No devices found!')

sys.exit(0)
