# OscilloscopeCombineWCMI.py
#
# This example demonstrates how to create and open a combined instrument of all found Handyscope HS5, Handyscope HS6, Handyscope HS6 DIFF,
# WiFiScope WS5, WiFiScope WS6 and/or WiFiScope WS6 DIFFs.
# All instrument must have a Wireless Multi Instrument Synchronization Module WCMI connected prior to starting this script.
#
# Find more information on:
#    https://www.tiepie.com/libtiepie
#    https://www.tiepie.com/wcmi
#

import sys
import libtiepie
from printinfo import *

# Print library info:
print_library_info()

# Search for devices:
libtiepie.device_list.update()

# Try to open all HS3/HS4(D) oscilloscopes:
allowedProductIDs = [libtiepie.PRODUCTID_HS5, libtiepie.PRODUCTID_HS6, libtiepie.PRODUCTID_HS6D, libtiepie.PRODUCTID_WS5, libtiepie.PRODUCTID_WS6, libtiepie.PRODUCTID_WS6D]
scps = []
for item in libtiepie.device_list:
    if item.product_id in allowedProductIDs and item.can_open(libtiepie.DEVICETYPE_OSCILLOSCOPE):
        scp = item.open_oscilloscope()
        if scp:
            print(f'Found: {scp.name}, s/n: {scp.serial_number}')
            scps.append(scp)

if len(scps) > 1:
    try:
        print(f'Number of scopes: {len(scps)}')
        # Create and open combined instrument:
        scp = libtiepie.device_list.create_and_open_combined_device(scps)

        # Remove HS3/HS4(D) objects, not required anymore:
        del scps

        # Print combined oscilloscope info:
        print_device_info(scp)

        # Get serial number, required for removing:
        serial_number = scp.serial_number

        # Close combined oscilloscope:
        del scp

        # Remove combined oscilloscope from the device list:
        libtiepie.device_list.remove_device(serial_number)
    except Exception as e:
        print(f'Exception: {e}')
        sys.exit(1)

else:
    print(f'Not enough HS5 / HS6(D) / WS5 / WS6(D)s found ({len(scps)}), at least two required!')
    sys.exit(1)

sys.exit(0)
